<?php 

header("Access-Control-Allow-Origin:*"); 

header("Access-Control-Allow-Methods: POST, OPTIONS"); 

header("Access-Control-Allow-Headers: Content-Type"); 

header("Content-Type: application/json; charset=utf-8"); 

if($_SERVER["REQUEST_METHOD"]==="OPTIONS") exit; 

 

require_once "db.php"; 

$in=json_decode(file_get_contents("php://input"),true); 

$email=$in["email"]??""; $pwd=$in["password"]??""; 

if($email===""||$pwd===""){ http_response_code(400); 

  echo json_encode(["success"=>false,"message"=>"Faltan datos"]); exit; } 

 

$stmt=$conn->prepare("SELECT u.id,u.nombre,u.password_hash,r.nombre AS rol 

                      FROM usuarios u JOIN roles r ON r.id=u.rol_id 

                      WHERE u.email=? AND u.estado='ACTIVO' LIMIT 1"); 

$stmt->bind_param("s",$email); $stmt->execute(); 

$res=$stmt->get_result(); 

 

if($row=$res->fetch_assoc()){ 

  if(password_verify($pwd,$row["password_hash"])){ 

    echo json_encode(["success"=>true,"usuario"=>[ 

      "id"=>$row["id"],"nombre"=>$row["nombre"],"rol"=>$row["rol"] 

    ]]); 

  } else { http_response_code(401); 

    echo json_encode(["success"=>false,"message"=>"Contraseña incorrecta"]); } 

}else{ http_response_code(404); 

  echo json_encode(["success"=>false,"message"=>"Usuario no encontrado"]); } 