<?php 

header("Access-Control-Allow-Origin:*"); 

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS"); 

header("Access-Control-Allow-Headers: Content-Type"); 

header("Content-Type: application/json; charset=utf-8"); 

if($_SERVER["REQUEST_METHOD"]==="OPTIONS") exit; 

require_once "db.php"; 

function body(){ return json_decode(file_get_contents("php://input"), true) ?? []; } 

$method=$_SERVER["REQUEST_METHOD"]; 

if($method==="GET"){ 

  $q=$conn->query("SELECT id,nombre,descripcion,estado FROM categorias ORDER BY id DESC"); 

  $out=[]; while($r=$q->fetch_assoc()) $out[]=$r; echo json_encode($out); exit; 

} 

if($method==="POST"){ 

  $b=body(); if(($b["nombre"]??"")===""){ http_response_code(400); 

    echo json_encode(["success"=>false,"message"=>"Nombre requerido"]); exit; } 

  $st=$conn->prepare("INSERT INTO categorias (nombre,descripcion,estado) VALUES (?,?, 'ACTIVO')"); 

  $st->bind_param("ss",$b["nombre"],$b["descripcion"]); 

  echo json_encode(["success"=>$st->execute(),"message"=>$st->error?: "Categoría creada"]); exit; 

} 

if($method==="PUT"){ 

  $b=body(); $id=(int)($b["id"]??0); if(!$id){ http_response_code(400); 

    echo json_encode(["success"=>false,"message"=>"ID requerido"]); exit; } 

  $st=$conn->prepare("UPDATE categorias SET nombre=?, descripcion=?, estado=? WHERE id=?"); 

  $st->bind_param("sssi",$b["nombre"],$b["descripcion"],$b["estado"],$id); 

  echo json_encode(["success"=>$st->execute(),"message"=>$st->error?: "Categoría actualizada"]); exit; 

} 

if($method==="DELETE"){ 

  $id=(int)($_GET["id"] ?? (body()["id"] ?? 0)); if(!$id){ http_response_code(400); 

    echo json_encode(["success"=>false,"message"=>"ID requerido"]); exit; } 

  $st=$conn->prepare("DELETE FROM categorias WHERE id=?"); $st->bind_param("i",$id); 

  echo json_encode(["success"=>$st->execute(),"message"=>$st->error?: "Categoría eliminada"]); exit; 

} 

http_response_code(405); echo json_encode(["success"=>false,"message"=>"Método no permitido"]); 