<?php 

header("Access-Control-Allow-Origin:*"); 

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS"); 

header("Access-Control-Allow-Headers: Content-Type"); 

header("Content-Type: application/json; charset=utf-8"); 

if($_SERVER["REQUEST_METHOD"]==="OPTIONS") exit; 

require_once "db.php"; 

function body(){ return json_decode(file_get_contents("php://input"), true) ?? []; } 

$method=$_SERVER["REQUEST_METHOD"]; 


if($method==="GET"){ 

  $q=$conn->query("SELECT p.id,p.nombre,p.descripcion,p.precio,p.stock,p.estado,p.categoria_id,c.nombre AS categoria 

                   FROM productos p LEFT JOIN categorias c ON c.id=p.categoria_id 

                   ORDER BY p.id DESC"); 

  $out=[]; while($r=$q->fetch_assoc()) $out[]=$r; echo json_encode($out); exit; 

} 

if($method==="POST"){ 

  $b=body(); if(($b["nombre"]??"")==="" || !isset($b["precio"])){ http_response_code(400); 

    echo json_encode(["success"=>false,"message"=>"Nombre y precio requeridos"]); exit; } 

  $st=$conn->prepare("INSERT INTO productos (categoria_id,nombre,descripcion,precio,stock,estado) VALUES (?,?,?,?,?, 'ACTIVO')"); 

  $cat = empty($b["categoria_id"])? NULL : (int)$b["categoria_id"]; 

  $st->bind_param("issdi", $cat, $b["nombre"], $b["descripcion"], $b["precio"], $b["stock"]); 

  echo json_encode(["success"=>$st->execute(),"message"=>$st->error?: "Producto creado"]); exit; 

} 

if($method==="PUT"){ 

  $b=body(); $id=(int)($b["id"]??0); if(!$id){ http_response_code(400); 

    echo json_encode(["success"=>false,"message"=>"ID requerido"]); exit; } 

  $cat = empty($b["categoria_id"])? NULL : (int)$b["categoria_id"]; 

  $st=$conn->prepare("UPDATE productos SET categoria_id=?, nombre=?, descripcion=?, precio=?, stock=?, estado=? WHERE id=?"); 

  $st->bind_param("issdisi",$cat,$b["nombre"],$b["descripcion"],$b["precio"],$b["stock"],$b["estado"],$id); 

  echo json_encode(["success"=>$st->execute(),"message"=>$st->error?: "Producto actualizado"]); exit; 

} 

if($method==="DELETE"){ 

  $id=(int)($_GET["id"] ?? (body()["id"] ?? 0)); if(!$id){ http_response_code(400); 

    echo json_encode(["success"=>false,"message"=>"ID requerido"]); exit; } 

  $st=$conn->prepare("DELETE FROM productos WHERE id=?"); $st->bind_param("i",$id); 

  echo json_encode(["success"=>$st->execute(),"message"=>$st->error?: "Producto eliminado"]); exit; 

} 

http_response_code(405); echo json_encode(["success"=>false,"message"=>"Método no permitido"]); 