<?php 

header("Access-Control-Allow-Origin:*"); 

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS"); 

header("Access-Control-Allow-Headers: Content-Type"); 

header("Content-Type: application/json; charset=utf-8"); 

if($_SERVER["REQUEST_METHOD"]==="OPTIONS") exit; 

require_once "db.php"; 

function body(){ return json_decode(file_get_contents("php://input"), true) ?? []; } 

$method=$_SERVER["REQUEST_METHOD"]; 

if($method==="GET"){ 

  $q=$conn->query("SELECT u.id,u.nombre,u.email,u.estado,u.rol_id,r.nombre AS rol 

                   FROM usuarios u JOIN roles r ON r.id=u.rol_id ORDER BY u.id DESC"); 

  $out=[]; while($row=$q->fetch_assoc()) $out[]=$row; echo json_encode($out); exit; 

} 

if($method==="POST"){ 

  $b=body(); if(($b["nombre"]??"")===""||($b["email"]??"")===""||empty($b["rol_id"])){ 

    http_response_code(400); echo json_encode(["success"=>false,"message"=>"Datos incompletos"]); exit;} 

  $hash=password_hash($b["password"]??"123456", PASSWORD_DEFAULT); 

  $st=$conn->prepare("INSERT INTO usuarios(rol_id,nombre,email,password_hash,estado) VALUES (?,?,?,?, 'ACTIVO')"); 

  $st->bind_param("isss",$b["rol_id"],$b["nombre"],$b["email"],$hash); 

  echo json_encode(["success"=>$st->execute(),"message"=>$st->error?: "Usuario creado"]); exit; 

} 

if($method==="PUT"){ 

  $b=body(); $id=(int)($b["id"]??0); if(!$id){ http_response_code(400); 

    echo json_encode(["success"=>false,"message"=>"ID requerido"]); exit; } 

  if(!empty($b["password"])){ 

    $hash=password_hash($b["password"], PASSWORD_DEFAULT); 

    $st=$conn->prepare("UPDATE usuarios SET rol_id=?,nombre=?,email=?,password_hash=?,estado=? WHERE id=?"); 

    $st->bind_param("issssi",$b["rol_id"],$b["nombre"],$b["email"],$hash,$b["estado"],$id); 

  }else{ 

    $st=$conn->prepare("UPDATE usuarios SET rol_id=?,nombre=?,email=?,estado=? WHERE id=?"); 

    $st->bind_param("isssi",$b["rol_id"],$b["nombre"],$b["email"],$b["estado"],$id); 

  } 

  echo json_encode(["success"=>$st->execute(),"message"=>$st->error?: "Usuario actualizado"]); exit; 

} 

if($method==="DELETE"){ 

  $id=(int)($_GET["id"] ?? (body()["id"] ?? 0)); if(!$id){ http_response_code(400); 

    echo json_encode(["success"=>false,"message"=>"ID requerido"]); exit; } 

  $st=$conn->prepare("DELETE FROM usuarios WHERE id=?"); $st->bind_param("i",$id); 

  echo json_encode(["success"=>$st->execute(),"message"=>$st->error?: "Usuario eliminado"]); exit; 

} 

http_response_code(405); echo json_encode(["success"=>false,"message"=>"Método no permitido"]); 